/* -- Veralteter Stand -unr zur Dokumentation
CREATE OR REPLACE FUNCTION scheduling.ab2__worktime_done__get(
    _ab2_id int,
    _time_before timestamp = 'infinity'
  ) RETURNS numeric AS $$
DECLARE
    _bdea_record       record;

    _work_accomplished numeric := 0;
    _ta_kf             numeric;

    _debug_prefix      text := '[scheduling.ab2__worktime_done__get » ab2: ' || _ab2_id || ']';

BEGIN

    FOR _bdea_record IN (

        SELECT

          bdea.ba_efftime,

          -- kf for ksv defined in bdea
          -- this functions as fallback, when the abk was reterminated
          -- TODO: Prüfen, ob der tf_bdea.ta_kf hier genutzt werden kann? (Standardmäßig wird resource_ks_ta_kf verwendet. Nur wenn das nicht ermittelt werden konnte, wird tf_bdea.ta_kf als Korrekturfaktor verwendet.)
          tf_bdea.ta_kf AS bdea_ks_ta_kf,

          -- kf as defined for the resource in scheduling.resource_timeline
          tf_resource AS resource_ks_ta_kf
        FROM bdea
        JOIN ab2 ON ab2.a2_ab_ix = bdea.ba_ix AND ab2.a2_n = bdea.ba_op
        LEFT JOIN LATERAL (
          SELECT ti_ta_kf as tf_resource
          FROM scheduling.resource_timeline rt
          WHERE
                ab2.a2_id = rt.ti_a2_id
            AND
              -- [x] AXS: Stempelung ausserhalb des geplanten Timerange.--> Wird auch als abgearbeitet gewertet. Der Filter mit den tsranges wird nur in der Ermittelung des Korrekturfaktors verwendet.
              -- TODO: Klärung: a2_time_stemp => aggregierte Stempelzeit?
              -- TODO: Klärung: Wie ermittelt Terminierung die benötigte Arbeitszeit? (eigentlich: a2_ta - a2_time_stemp) -> Verwendet wird diese DB-Funktion, um die bereits erledigte Zeit aus der Stemperlung zu ermitteln.
                   tsrange( rt.ti_date_start::date, rt.ti_date_end::date, '[]' )
                && tsrange( bdea.ba_anf::date, bdea.ba_end::date, '[]')
            AND ti_type = 'task'
          GROUP BY ti_resource_id, ti_ta_kf

        ) resource_timeline ON true

        LEFT JOIN LATERAL  scheduling.resource_timeline__timeslots_ta_kf__calc( ba_anf, ba_anf, _ks_abt => ba_ks ) tf_bdea ON true

        WHERE
              a2_id = _ab2_id
          AND ba_end <= _time_before


    ) LOOP

        -- if scheduling.resource_timeline is present, than that will be used
        -- otherwise fall back to ksv given in bdea
        IF ( _bdea_record.resource_ks_ta_kf IS NOT null ) THEN

            _ta_kf := _bdea_record.resource_ks_ta_kf;
            RAISE NOTICE '% using resource data', _debug_prefix;
        ELSE

            _ta_kf := _bdea_record.bdea_ks_ta_kf;
            RAISE NOTICE '% using ksv data', _debug_prefix;
        END IF;

        -- overwrite kf to 1 if its zero but time was done
        -- this might better be the default kf for that ksv during a workday
        IF ( _ta_kf = 0 ) THEN

            _ta_kf := 1;
            RAISE NOTICE '% overwrite ta_kf due to the KF beeing 0 at the time of time recording', _debug_prefix;

        END IF;

        _work_accomplished :=
              _work_accomplished
            + _bdea_record.ba_efftime * _ta_kf;

    END LOOP;

    RETURN _work_accomplished * 60 * 60;

END $$ language plpgsql;
*/


/*  Ermittle für einen gegebenen AG die bereits erledigte Arbeitszeit aus den Stempelzeiten.

    Gestemplete Arbeitszeiten sind immer effektive Arbeitszeiten.
*/
SELECT tsystem.function__drop_by_regex( 'ab2__worktime_done__get', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.ab2__worktime_done__get(
    _ab2 ab2,                           -- Der Arbeitsgang (ID) für den die erledigte Arbeitszeit ermittelt werden soll.
    _time_before timestamp = 'infinity' -- Der maximale Endzeitpunkt von Stempeleinträgen bis zu dem Stempelungen berücksichtigt werden.
    ) RETURNS numeric AS $$

    SELECT
      coalesce(
          sum(
              -- TODO AXS: Laufende Anstempelung mit berücksichtigen. Siehe Funktion tplanterm.get_ksview() stempz-Berechnung.
              -- TODO AXS: Stempelung auf anderer Ressource ausfiltern.
              ba_efftime
          ),
          0
      ) * ( 60 * 60 )
    FROM bdea
    WHERE _ab2.a2_time_stemp > 0 -- sont gibt es kein bdea!
          AND bdea.ba_ix = _ab2.a2_ab_ix
          AND bdea.ba_op = _ab2.a2_n
          AND ba_anf <= _time_before

    -- beachte
    -- * bdea__ba_efftime__sum__by__params__get


  $$ LANGUAGE sql STABLE STRICT PARALLEL SAFE;


CREATE OR REPLACE FUNCTION scheduling.ab2__worktime_done__get(
    _ab2_id int,                        -- Der Arbeitsgang (ID) für den die erledigte Arbeitszeit ermittelt werden soll.
    _time_before timestamp = 'infinity' -- Der maximale Endzeitpunkt von Stempeleinträgen bis zu dem Stempelungen berücksichtigt werden.
    ) RETURNS numeric AS $$

    SELECT scheduling.ab2__worktime_done__get(ab2, _time_before) FROM ab2 WHERE a2_id = _ab2_id;


  $$ LANGUAGE sql STABLE STRICT PARALLEL SAFE;